<?php
// config.php - Configuration du serveur API
// Groupe 4 Sécurité

return [
    // ===== SÉCURITÉ =====
    'API_KEY' => 'G4_SECURITY_KEY_' . date('Y'),
    'GROUP_ID' => 'G4',
    'REQUIRE_HTTPS' => true,
    'ALLOWED_IPS' => [
        // '127.0.0.1',
        // '::1'
    ],
    
    // ===== STOCKAGE =====
    'STORAGE_DIR' => __DIR__ . '/data/',
    'MAX_FILE_SIZE' => 5242880, // 5MB
    'MAX_SESSIONS_PER_GROUP' => 1000,
    'SESSION_EXPIRE_DAYS' => 30,
    
    // ===== JOURNALISATION =====
    'ENABLE_LOGS' => true,
    'LOG_LEVEL' => 'INFO', // DEBUG, INFO, WARNING, ERROR
    'LOG_RETENTION_DAYS' => 7,
    
    // ===== PERFORMANCE =====
    'ENABLE_COMPRESSION' => true,
    'CACHE_ENABLED' => true,
    'CACHE_TTL' => 300, // 5 minutes
    
    // ===== API LIMITS =====
    'RATE_LIMIT_ENABLED' => true,
    'RATE_LIMIT_REQUESTS' => 100,
    'RATE_LIMIT_PERIOD' => 60, // secondes
    
    // ===== NOTIFICATIONS =====
    'EMAIL_NOTIFICATIONS' => false,
    'ADMIN_EMAIL' => 'admin@votredomaine.com',
    'ALERT_ON_ERROR' => true,
    
    // ===== MAINTENANCE =====
    'MAINTENANCE_MODE' => false,
    'MAINTENANCE_MESSAGE' => 'API en maintenance',
    
    // ===== VERSION =====
    'API_VERSION' => '1.0.0',
    'MIN_CLIENT_VERSION' => '1.0.0',
    
    // ===== BACKUP =====
    'BACKUP_ENABLED' => true,
    'BACKUP_SCHEDULE' => 'daily', // daily, weekly, monthly
    'BACKUP_RETENTION' => 7, // jours
    'BACKUP_DIR' => __DIR__ . '/backups/',
    
    // ===== STATISTIQUES =====
    'STATS_ENABLED' => true,
    'STATS_RETENTION' => 30, // jours
    
    // ===== DÉVELOPPEMENT =====
    'DEBUG_MODE' => false,
    'SHOW_ERRORS' => false,
    'CORS_ALLOWED_ORIGINS' => ['*'],
    
    // ===== CHIFFREMENT (optionnel) =====
    'ENCRYPTION_ENABLED' => false,
    'ENCRYPTION_KEY' => '',
    'ENCRYPTION_METHOD' => 'AES-256-CBC',
    
    // ===== BASE DE DONNÉES (optionnel) =====
    'DB_ENABLED' => false,
    'DB_HOST' => 'localhost',
    'DB_NAME' => 'cookies_db',
    'DB_USER' => 'root',
    'DB_PASS' => '',
    'DB_TABLE' => 'sessions',
    
    // ===== GESTION DES FICHIERS =====
    'FILE_PERMISSIONS' => 0644,
    'DIR_PERMISSIONS' => 0755,
    'ALLOWED_FILE_TYPES' => ['json'],
    
    // ===== AUTHENTIFICATION AVANCÉE =====
    'REQUIRE_USER_AGENT' => true,
    'BLOCK_TOR' => true,
    'BLOCK_PROXIES' => true,
    
    // ===== MONITORING =====
    'MONITORING_ENABLED' => true,
    'UPTIME_CHECK' => true,
    'DISK_SPACE_ALERT' => 90, // pourcentage
    'MEMORY_ALERT' => 80, // pourcentage
];
?>